<?php
/*
    @author     : Surdeanu Mihai ;
    @date       : 20 august 2010 ;
    @version    : 1.0 ;
    @mybb       : compatibility with MyBB 1.4.x and with MyBB 1.6.x;
    @description: This plugin show the forum age on index page (on footer page)!
    @homepage   : http://homesoftcenter.com/forum ! Please visit us now!
    @copyright  : GPL License. All rights reserved. 
*/
//Test myBB
if(!defined("IN_MYBB"))
{
    die("Acest fisier nu poate fi accesat direct.");
}
//Our hook
$plugins->add_hook("index_start", "forumage_start");
//Plugin information
function forumage_info()
{
    return array(
        "name"				=> "هاك عمر المنتدي",
        "description"		=> "يظهر عمر المنتدي والمدة الزمنية.",
        "website"			=> "http://www.homesoftcenter.com/forum",
        "author"			=> "Mihu",
        "authorsite"		=> "mailto:mihu@homesoftcenter.com",
        "version"			=> "1.0",
		"guid"				=> "b6ad0bfae46d194b803e5c5389c7ebf1",
		'compatibility'     => '14*,16*',
                );
}
//Activate plugin
function forumage_activate()
{
	global $db;
	$grup_de_setari = array(
		"gid"               => NULL,
		"name"              => "fa_hsc",
		"title"             => "هاك عمر المنتدي",
		"description"       => "اعدادات الهاك",
		"disporder"         => "35",
		"isdefault"         => "no"
                           );
	$db->insert_query("settinggroups", $grup_de_setari);
	$gid = $db->insert_id();
    $setare_1 = array(
        "sid"               => NULL,
        "name"              => "fa_enabled",
        "title"             => "تفعيل / ايقاف",
        "description"       => "تستطيع ايقاف او تشغيل الهاك من هنا",
        "optionscode"       => "yesno",
        "value"             => "no",
        "disporder"         => "1",
        "gid"               => intval($gid)
                     );
    $setare_2 = array(
        "sid"               => NULL,
        "name"              => "fa_mode",
        "title"             => "نظام الوقع",
        "description"       => "قم باختيار الوقع المناسب ويفضل تركه كما هو",
        "optionscode"       => "select\n0=Simple Mode\n1=Advanced Mode",
        "value"             => "0",
        "disporder"         => "2",
        "gid"               => intval($gid)
                     );
    $setare_3 = array(
        "sid"               => NULL,
        "name"              => "fa_list",
        "title"             => "مظهر العرض",
        "description"       => "قم باختيار معظر العرض المناسب لك",
        "optionscode"       => "select\n0=سنوات,شهور,ايام\n1=سنوات,شهور,ايام,ساعات\n2=سنوات,شهور,ايام,ساعات,دقائق",
        "value"             => "0",
        "disporder"         => "3",
        "gid"               => intval($gid)
                     );
	$db->insert_query("settings", $setare_1); 
    $db->insert_query("settings", $setare_2);  
    $db->insert_query("settings", $setare_3);  
    rebuild_settings(); 
    $sablon = array(
		"tid"		=> NULL,
		"title"		=> "fa_template",
		"template"	=> "{\$fa_final}",
		"sid"		=> "-1"
	                 );
	$db->insert_query("templates", $sablon);
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("index_boardstats", '#{\$forumstats}#', "{\$forumstats}\n{\$faforumage}");
}
//Deactivate plugin
function forumage_deactivate()
{
	global $db;
    $db->delete_query('settings', 'name IN("fa_enabled","fa_mode","fa_list")');
    $db->delete_query('settinggroups', 'name = "fa_hsc"');
    rebuild_settings();
    $db->delete_query('templates', 'title = "fa_template"');  
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("index_boardstats", '#(\n?){\$faforumage}#', '', 0);
}
//Aditional functions
function forumage_get($diferenta)
{
    $ani = floor($diferenta / (365*60*60*24));
    $luni = floor(($diferenta - $ani * 365*60*60*24) / (30*60*60*24));
    $zile = floor(($diferenta - $ani*365*60*60*24 - $luni*30*60*60*24)/ (60*60*24));
    $ore = floor(($diferenta - $ani*365*60*60*24 - $luni*30*60*60*24 - $zile*60*60*24)/ (60*60)); 
    $minute = floor(($diferenta - $ani*365*60*60*24 - $luni*30*60*60*24 - $zile*60*60*24 - $ore*60*60)/ 60);  
    return "".$ani."|".$luni."|".$zile."|".$ore."|".$minute."";
}
function forumage_parse($ani,$luni,$zile,$ore,$minute,$timp)
{
    global $lang,$mybb;
    $lang->load("forumage");  
    $v = ",";
    $a = $lang->fa_and;
    if (($ani == "0")&&($luni == "0"))
        switch ($mybb->settings['fa_list'])
        {
        case 0 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$zile."".$lang->fa_days."."; 
        break;
        case 1 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$zile."".$lang->fa_days." ".$a." ".$ore."".$lang->fa_hours."."; 
        break;
        case 2 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$zile."".$lang->fa_days."".$v." ".$ore."".$lang->fa_hours." ".$a." ".$minute."".$lang->fa_minutes."."; 
        break;
        }
    else
    {
    if ($ani == "0")
        switch ($mybb->settings['fa_list'])
        {
        case 0 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$luni."".$lang->fa_months." ".$a." ".$zile."".$lang->fa_days."."; 
            break;
        case 1 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$luni."".$lang->fa_months."".$v." ".$zile."".$lang->fa_days." ".$a." ".$ore."".$lang->fa_hours."."; 
            break;
        case 2 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$luni."".$lang->fa_months."".$v." ".$zile."".$lang->fa_days."".$v." ".$ore."".$lang->fa_hours." ".$a." ".$minute."".$lang->fa_minutes."."; 
            break;
        }
    else
        switch ($mybb->settings['fa_list'])
        {
        case 0 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$ani."".$lang->fa_years."".$v." ".$luni."".$lang->fa_months." ".$a." ".$zile."".$lang->fa_days.".";
            break;
        case 1 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$ani."".$lang->fa_years."".$v." ".$luni."".$lang->fa_months."".$v." ".$zile."".$lang->fa_days." ".$a." ".$ore."".$lang->fa_hours."."; 
            break;
        case 2 :
            return $lang->fa_boardstartedon1."".date('m-d-Y',$timp)."".$lang->fa_boardstartedon2."".$ani."".$lang->fa_years."".$v." ".$luni."".$lang->fa_months."".$v." ".$zile."".$lang->fa_days."".$v." ".$ore."".$lang->fa_hours." ".$a." ".$minute."".$lang->fa_minutes."."; 
            break;
        }   
    }
}
//Functia de initializare
function forumage_start()
{
    //Variabile globale
    global $db, $mybb, $faforumage, $templates;
    //Variabile de lucru
    $final = "";
    if ($mybb->settings['fa_enabled'] == 1)  
    {
        //Se realizeaza interogarea
        $interogare = $db->simple_select("users","regdate","",array("order_by"=>'uid',"limit"=>1));
        //Se intoarce din baza de date primul user inregistrat pe forum (admin)
        $user = $db->fetch_array($interogare);
        $data_inregistrarii = $user['regdate'];
        $data_acum = time();
        //Diferenta de timp este = ...
        $diferenta = $data_acum - $data_inregistrarii;
        $rezultat = explode('|',forumage_get($diferenta)); 
        //Se parseaza datele obtinute si se formeaza string-ul final 
        $final = forumage_parse($rezultat[0],$rezultat[1],$rezultat[2],$rezultat[3],$rezultat[4],$data_inregistrarii);  
        if ($mybb->settings['fa_mode'] == 1)  
        {  
        //Advanced Mode - template
        $fa_final = "<tr>
                        <td class=\"trow1 smalltext\" align=\"center\" width=\"1\"><img src=\"images/fa_image.png\" alt=\"Group Legend\" />
                        </td>
                        <td colspan=\"6\" class=\"trow1\">
                        <span class=\"smalltext\">
                                ".$final."
                        </span>
                        </td>
                      </tr>";
        }
        else
        {
        //Simple Mode - template    
        $fa_final = "<tr>
                        <td class=\"trow1\">
                        <span class=\"smalltext\">
                                ".$final." 
                        </span>
                        </td>
                      </tr>";
        }
    }
    else
    {
        $fa_final = "";
    }
	eval("\$faforumage = \"".$templates->get("fa_template")."\";"); 
}
?>